package ru.yandex.solomon.idempotency;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Any;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.solomon.core.container.ContainerType;
import ru.yandex.solomon.idempotency.dao.IdempotentOperationDao;

/**
 * @author Alexey Trushkin
 */
public class IdempotentOperationServiceImpl implements IdempotentOperationService {
    private final IdempotentOperationDao dao;

    public IdempotentOperationServiceImpl(IdempotentOperationDao dao) {
        this.dao = dao;
    }

    @Override
    public CompletableFuture<Optional<IdempotentOperation>> get(String id, String containerId, ContainerType containerType, String type) {
        if (StringUtils.isEmpty(id)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return dao.get(id, containerId, containerType, type);
    }

    @Override
    public CompletableFuture<Boolean> delete(String id, String containerId, ContainerType containerType, String type) {
        if (StringUtils.isEmpty(id)) {
            return CompletableFuture.completedFuture(false);
        }
        return dao.deleteOne(new IdempotentOperation(id, containerId, containerType, type, "", Any.getDefaultInstance(), 0));
    }
}
