package ru.yandex.solomon.idempotency.dao;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.container.ContainerType;
import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.idempotency.IdempotentOperation;

/**
 * @author Alexey Trushkin
 */
public interface IdempotentOperationDao extends SchemaAwareDao {

    CompletableFuture<Optional<IdempotentOperation>> get(String id, String containerId, ContainerType containerType, String operationType);

    CompletableFuture<Boolean> complete(IdempotentOperation operation);

    CompletableFuture<Boolean> deleteOne(IdempotentOperation operation);
}
