package ru.yandex.solomon.idempotency.dao.memory;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.container.ContainerType;
import ru.yandex.solomon.idempotency.IdempotentOperation;
import ru.yandex.solomon.idempotency.dao.IdempotentOperationDao;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class InMemoryIdempotentOperationDao implements IdempotentOperationDao {

    private final ConcurrentMap<String, IdempotentOperation> byId = new ConcurrentHashMap<>();

    @Override
    public CompletableFuture<Void> createSchemaForTests() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> dropSchemaForTests() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> complete(IdempotentOperation operation) {
        var key = operation.id() + operation.containerId() + operation.containerType() + operation.operationType();
        return CompletableFuture.supplyAsync(() -> byId.putIfAbsent(key, operation) == null);
    }

    @Override
    public CompletableFuture<Boolean> deleteOne(IdempotentOperation operation) {
        var opKey = operation.id() + operation.containerId() + operation.containerType() + operation.operationType();
        return CompletableFuture.supplyAsync(() -> byId.remove(opKey) != null);
    }

    @Override
    public CompletableFuture<Optional<IdempotentOperation>> get(String id, String containerId, ContainerType containerType, String operationType) {
        var key = id + containerId + containerType + operationType;
        return CompletableFuture.supplyAsync(() -> Optional.ofNullable(byId.get(key)));
    }

}
