package ru.yandex.solomon.idempotency.dao.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
class YdbIdempotentOperationQuery {

    private static final String SELECT_ONE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $containerId AS Utf8;
            DECLARE $containerType AS Utf8;
            DECLARE $operationType AS Utf8;

            SELECT * FROM `TABLE` WHERE id = $id and containerId = $containerId and containerType = $containerType and operationType = $operationType;
            """;

    private static final String COMPLETE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $containerId AS Utf8;
            DECLARE $containerType AS Utf8;
            DECLARE $operationType AS Utf8;
            DECLARE $entityId AS Utf8;
            DECLARE $result AS String;
            DECLARE $completedAt AS Timestamp;

            INSERT INTO `TABLE`(id, containerId, containerType, operationType, entityId, result, completedAt)
            VALUES ($id, $containerId, $containerType, $operationType, $entityId, $result, $completedAt);
            """;

    private static final String DELETE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $containerId AS Utf8;
            DECLARE $containerType AS Utf8;
            DECLARE $operationType AS Utf8;

            SELECT TRUE AS value
            FROM `TABLE`
            WHERE id = $id and containerId = $containerId and containerType = $containerType and operationType = $operationType;

            DELETE FROM `TABLE`
            WHERE id = $id and containerId = $containerId and containerType = $containerType and operationType = $operationType;
            """;

    final String root;
    final String table;
    final String complete;
    final String selectOne;
    final String deleteOne;

    public YdbIdempotentOperationQuery(String root) {
        this.root = root;
        this.table = root + "/IdempotentOperation";
        this.selectOne = prepare(SELECT_ONE);
        this.complete = prepare(COMPLETE);
        this.deleteOne = prepare(DELETE);
    }

    private String prepare(String query) {
        return query
                .replaceAll("TABLE", table);
    }
}
