package ru.yandex.solomon.idempotency.dao.ydb;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.ydb.core.Status;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.settings.AutoPartitioningPolicy;
import com.yandex.ydb.table.settings.CreateTableSettings;
import com.yandex.ydb.table.settings.PartitioningPolicy;
import com.yandex.ydb.table.settings.TtlSettings;
import com.yandex.ydb.table.values.PrimitiveType;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
class YdbIdempotentOperationTable {

    static String ID = "id";
    static String PARAM_ID = "$" + ID;
    static String CONTAINER_ID = "containerId";
    static String PARAM_CONTAINER_ID = "$" + CONTAINER_ID;
    static String CONTAINER_TYPE = "containerType";
    static String PARAM_CONTAINER_TYPE = "$" + CONTAINER_TYPE;
    static String OPERATION_TYPE = "operationType";
    static String PARAM_OPERATION_TYPE = "$" + OPERATION_TYPE;
    static String ENTITY_ID = "entityId";
    static String PARAM_ENTITY_ID = "$" + ENTITY_ID;
    static String RESULT = "result";
    static String PARAM_RESULT = "$" + RESULT;
    static String COMPLETED_AT = "completedAt";
    static String PARAM_COMPLETED_AT = "$" + COMPLETED_AT;

    static CompletableFuture<Status> createTable(String tablePath, Session session) {
        var table = TableDescription.newBuilder()
                .addNullableColumn(ID, PrimitiveType.utf8())
                .addNullableColumn(CONTAINER_ID, PrimitiveType.utf8())
                .addNullableColumn(CONTAINER_TYPE, PrimitiveType.utf8())
                .addNullableColumn(OPERATION_TYPE, PrimitiveType.utf8())
                .addNullableColumn(ENTITY_ID, PrimitiveType.utf8())
                .addNullableColumn(RESULT, PrimitiveType.string())
                .addNullableColumn(COMPLETED_AT, PrimitiveType.timestamp())
                .setPrimaryKeys(ID, CONTAINER_ID, CONTAINER_TYPE, OPERATION_TYPE)
                .build();

        var settings = new CreateTableSettings();
        settings.setTtlSettings(new TtlSettings(COMPLETED_AT, (int) TimeUnit.DAYS.toSeconds(2)));
        settings.setPartitioningPolicy(new PartitioningPolicy().setAutoPartitioning(AutoPartitioningPolicy.AUTO_SPLIT_MERGE));
        settings.setTimeout(10, TimeUnit.SECONDS);

        return session.createTable(tablePath, table, settings);
    }
}
