package ru.yandex.solomon.idempotency.dao.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.idempotency.dao.AbstractIdempotentOperationDaoTest;
import ru.yandex.solomon.idempotency.dao.IdempotentOperationDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class YdbIdempotentOperationDaoTest extends AbstractIdempotentOperationDaoTest {
    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbIdempotentOperationDao dao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        dao = new YdbIdempotentOperationDao(ydb.getRootPath(), ydb.getTableClient(), ydb.getSchemeClient());
        dao.createSchemaForTests().join();
    }

    @After
    public void tearDown() {
        join(dao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public IdempotentOperationDao getDao() {
        return dao;
    }
}
