package ru.yandex.kikimr.client;

/**
 * @author Stepan Koltsov
 *
 * yql/minikql/mkql_engine.h
 * NMiniKql::IEngine::EResult
 */
public enum ExecutionEngineStatus implements KikimrCppEnum {
    Unknown(0),
    Ok(1),
    SchemeChanged(2),
    IsReadonly(3),
    KeyError(4),
    ProgramError(5),
    TooManyShards(6),
    TooManyData(7),
    SnapshotNotExist(8),
    SnapshotNotReady(9),
    ;
    private final int cppValue;

    ExecutionEngineStatus(int cppValue) {
        this.cppValue = cppValue;
    }

    @Override
    public int cppValue() {
        return cppValue;
    }

    public static final Resolver<ExecutionEngineStatus> R = new Resolver<>(ExecutionEngineStatus.class);
}
