package ru.yandex.kikimr.client;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Message;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class KikimrAnyResponseException extends KikimrMessageException {

    @Nonnull
    protected final Message response;

    public KikimrAnyResponseException(Message response, String op) {
        this(response, op, "");
    }

    public KikimrAnyResponseException(Message response, String op, String message) {
        super(ResposeUtils.printToSingleLine(response) + "; " + op + (message.isEmpty() ? message : (": " + message)));
        this.response = response;
    }

    @Override
    @Nonnull
    public Message getResponse() {
        return response;
    }

} //~
