package ru.yandex.kikimr.client;

import java.util.Optional;

/**
 * @author Stepan Koltsov
 */
public interface KikimrCppEnum {

    int cppValue();

    class Resolver<E extends Enum<?> & KikimrCppEnum> {
        private final Class<E> enumClass;

        public Resolver(Class<E> enumClass) {
            this.enumClass = enumClass;
        }

        public Optional<E> byCppValue(int cppValue) {
            for (E e : enumClass.getEnumConstants()) {
                if (e.cppValue() == cppValue) {
                    return Optional.of(e);
                }
            }
            return Optional.empty();
        }

        public String toString(int value) {
            return byCppValue(value).map(E::name).orElseGet(() -> Integer.toString(value));
        }
    }

} //~
