package ru.yandex.kikimr.client;

import java.util.concurrent.CompletableFuture;

import ru.yandex.kikimr.proto.Msgbus;
import ru.yandex.kikimr.proto.MsgbusKv;


/**
 * @author Sergey Polovko
 */
public interface KikimrTransport extends AutoCloseable {

    CompletableFuture<Msgbus.TResponse> schemeOperation(Msgbus.TSchemeOperation request);

    CompletableFuture<Msgbus.TResponse> schemeOperationStatus(Msgbus.TSchemeOperationStatus request);

    CompletableFuture<Msgbus.TResponse> schemeDescribe(Msgbus.TSchemeDescribe request);

    CompletableFuture<Msgbus.TLocalEnumerateTabletsResult> localEnumerateTablets(Msgbus.TLocalEnumerateTablets request);

    CompletableFuture<MsgbusKv.TKeyValueResponse> keyValue(MsgbusKv.TKeyValueRequest request);

    @Override
    void close();
}
