package ru.yandex.kikimr.client;

import java.util.function.Supplier;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;

import ru.yandex.kikimr.proto.Base;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ReplyStatus {

    public static void checkOk(int status, Supplier<String> message) {
        if (status != Base.EReplyStatus.OK_VALUE && status != Base.EReplyStatus.NODATA_VALUE) {
            throw new KikimrException(
                enumValueToString(status, Base.EReplyStatus.getDescriptor()) + ": " + message.get());
        }
    }

    public static void checkOk(int status, MessageOrBuilder request, MessageOrBuilder response) {
        checkOk(status,
            () -> {
                return "req: " + formatMessage(request)
                    + ", resp: " + formatMessage(response);
            });
    }

    private static String formatMessage(MessageOrBuilder message) {
        return message.getDescriptorForType().getName()
            + " " + trimTooLong(ResposeUtils.printToSingleLine(message));
    }

    @Nonnull
    public static String trimTooLong(String message) {
        if (message.length() < 100) {
            return message;
        } else {
            return message.substring(0, 90) + "...";
        }
    }

    @Nonnull
    public static String enumValueToString(int value, Descriptors.EnumDescriptor enumDescriptor) {
        Descriptors.EnumValueDescriptor valueDescriptor = enumDescriptor.findValueByNumber(value);
        if (valueDescriptor != null) {
            return valueDescriptor.getName();
        } else {
            return Integer.toString(value);
        }
    }
}
