package ru.yandex.kikimr.client;

/**
 * @author Stepan Koltsov
 *
 * kikimr/core/client/base/msgbus.h
 */
public enum ResponseStatus implements KikimrCppEnum {
    MSTATUS_UNKNOWN(0),
    MSTATUS_OK(1),
    MSTATUS_ERROR(128),
    MSTATUS_INPROGRESS(129),
    MSTATUS_TIMEOUT(130),
    MSTATUS_NOTREADY(131),
    MSTATUS_ABORTED(132),
    MSTATUS_INTERNALERROR(133),
    MSTATUS_REJECTED(134),
    ;

    private final int cppValue;

    ResponseStatus(int cppValue) {
        this.cppValue = cppValue;
    }

    @Override
    public int cppValue() {
        return cppValue;
    }

    public boolean isSuccess(boolean read) {
        switch (this) {
            case MSTATUS_OK:
                return true;
            case MSTATUS_INPROGRESS:
                return !read;
            default:
                return false;
        }
    }

    public static final KikimrCppEnum.Resolver<ResponseStatus> R = new Resolver<>(ResponseStatus.class);

    public static boolean isSuccess(int value, boolean read) {
        return R.byCppValue(value).map(r -> r.isSuccess(read)).orElse(false);
    }

    public static ResponseStatus valueOf(int code) {
        for (ResponseStatus status : ResponseStatus.values()) {
            if (code == status.cppValue) {
                return status;
            }
        }

        return ResponseStatus.MSTATUS_UNKNOWN;
    }

}
