package ru.yandex.kikimr.client;

import java.io.PrintWriter;
import java.io.StringWriter;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;

/**
 * @author Stepan Koltsov
 */
public class ResposeUtils {

    private static void printOneField(MessageOrBuilder response, Descriptors.FieldDescriptor field, PrintWriter out) {
        Message.Builder temp = response.getDefaultInstanceForType().newBuilderForType();

        if (field.isRepeated() || response.hasField(field)) {
            temp.setField(field, response.getField(field));
            out.write(TextFormat.printToUnicodeString(temp));
        }
    }

    public static void print(MessageOrBuilder response, PrintWriter out) {
        for (Descriptors.FieldDescriptor field : response.getDescriptorForType().getFields()) {
            if (field.isRepeated()) {
                printOneField(response, field, out);
            } else if (response.hasField(field)) {
                if (field.getName().equals("Status")) {
                    printEnum(response, out, field, ResponseStatus.R);
                } else if (field.getName().equals("ProxyErrorCode")) {
                    printEnum(response, out, field, UserProxyResultStatus.R);
                } else if (field.getName().equals("ExecutionEngineStatus")) {
                    printEnum(response, out, field, ExecutionEngineStatus.R);
                } else {
                    printOneField(response, field, out);
                }
            }
        }

        String unknownFieldsString = TextFormat.printToString(response.getUnknownFields());
        if (!unknownFieldsString.isEmpty()) {
            if (!unknownFieldsString.endsWith("\n")) {
                unknownFieldsString += "\n";
            }
            out.print(unknownFieldsString);
        }
    }

    private static <E extends Enum<?> & KikimrCppEnum> void printEnum(
            MessageOrBuilder response, PrintWriter out, Descriptors.FieldDescriptor field,
            KikimrCppEnum.Resolver<E> r)
    {
        Object value = response.getField(field);
        if (value instanceof Integer) {
            out.println(field.getName() + ": " + r.toString((int) value));
        } else {
            printOneField(response, field, out);
        }
    }

    public static String print(MessageOrBuilder response) {
        StringWriter stringWriter = new StringWriter();
        print(response, new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String printToSingleLine(MessageOrBuilder response) {
        return print(response).replace("\n", " ").replaceFirst(" $", "");
    }
}
