package ru.yandex.kikimr.client;


/**
 * @author Stepan Koltsov
 *
 * kikimr/core/tx/tx_proxy.h
 */
public enum UserProxyResultStatus implements KikimrCppEnum {

    Unknown(0),
    WrongRequest(1),
    EmptyAffectedSet(2),
    NotImplemented(3),
    ResolveError(4),

    ProxyNotReady(16),
    ProxyAccepted(17),
    ProxyResolved(18),
    ProxyPrepared(19),
    ProxyShardNotAvailable(20),
    ProxyShardTryLater(21),
    ProxyShardOverloaded(22),

    CoordinatorDeclined(32),
    CoordinatorOutdated(33),
    CoordinatorAborted(34),
    CoordinatorPlanned(35),
    CoordinatorUnknown(36),

    ExecComplete(48),
    ExecAlready(49),
    ExecAborted(50),
    ExecTimeout(51),
    ExecError(52),

    SynthBackendError(64),
    SynthNoProxy(65),
    ;

    private final int cppValue;

    UserProxyResultStatus(int cppValue) {
        this.cppValue = cppValue;
    }

    @Override
    public int cppValue() {
        return cppValue;
    }

    public boolean isOk() {
        switch (this) {
            case ExecComplete:
            case ExecAlready:
                return true;
            default:
                return false;
        }
    }

    public static final KikimrCppEnum.Resolver<UserProxyResultStatus> R = new Resolver<>(UserProxyResultStatus.class);

}
