package ru.yandex.kikimr.client.discovery;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

import com.google.common.net.HostAndPort;

/**
 * @author Vladimir Gordiychuk
 */
public class StaticDiscovery implements Discovery {
    private final Set<HostAndPort> addresses;
    private final CompletableFuture<Void> onChange = new CompletableFuture<>();

    public StaticDiscovery(Collection<HostAndPort> addresses) {
        this.addresses = Set.copyOf(addresses);
    }

    @Override
    public Set<HostAndPort> addresses() {
        return addresses;
    }

    @Override
    public CompletionStage<Void> forceUpdate() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<Void> onChange() {
        return onChange;
    }
}
