package ru.yandex.kikimr.client.discovery;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;

import com.google.common.net.HostAndPort;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

/**
 * @author senyasdr
 */
public class StaticNodeDiscovery implements NodeDiscovery {

    private Int2ObjectOpenHashMap<HostAndPort> addresses;
    private AtomicReference<CompletableFuture<Void>> onChange = new AtomicReference<>();

    public StaticNodeDiscovery(Map<Integer, HostAndPort> addresses) {
        this.addresses = new Int2ObjectOpenHashMap<>(addresses);
    }

    @Override
    public Set<HostAndPort> addresses() {
        return Set.copyOf(addresses.values());
    }

    @Override
    public CompletionStage<Void> forceUpdate() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<Void> onChange() {
        return onChange.updateAndGet(prev -> {
            if (prev != null) {
                return prev;
            }
            return new CompletableFuture<>();
        });
    }

    @Override
    public Int2ObjectOpenHashMap<HostAndPort> nodeIdToAddresses() {
        return addresses;
    }

    public void updateAddresses(Map<Integer, HostAndPort> addresses) {
        var doneFeature = this.onChange.getAndSet(null);
        this.addresses = new Int2ObjectOpenHashMap<>(addresses);
        if (doneFeature != null) {
            doneFeature.complete(null);
        }
    }

}
