package ru.yandex.kikimr.client.kv;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.kikimr.proto.MsgbusKv;
import ru.yandex.kikimr.util.NameRange;

/**
 * @author senyasdr
 */
@ParametersAreNonnullByDefault
public class KikimrClientProxy implements KikimrKvClient {

    private volatile KikimrKvClient client;

    private final KikimrKvClient clientV1;
    private final KikimrKvClient clientV2;

    public KikimrClientProxy(KikimrKvClient clientV1, @Nullable KikimrKvClient clientV2, boolean isV2ClientEnabled) {
        this.clientV1 = clientV1;
        this.clientV2 = clientV2;
        this.client = isV2ClientEnabled ? clientV2 : clientV1;
    }

    @Override
    public void setDoNotExceedFileSizeForTest(int doNotExceedFileSize) {
        client.setDoNotExceedFileSizeForTest(doNotExceedFileSize);
    }

    @Override
    public int getDoNotExceedFileSize() {
        return client.getDoNotExceedFileSize();
    }

    @Override
    public void close() {
        clientV1.close();
        if (clientV2 != null) {
            clientV2.close();
        }
    }

    @Override
    public CompletableFuture<Void> createKvTablets(String path, int count) {
        return client.createKvTablets(path, count);
    }

    @Override
    public CompletableFuture<Void> alterKvTablets(String path, int count) {
        return client.alterKvTablets(path, count);
    }

    @Override
    public CompletableFuture<Void> dropKvTablets(String path) {
        return client.dropKvTablets(path);
    }

    @Override
    public CompletableFuture<long[]> resolveKvTablets(String path) {
        return client.resolveKvTablets(path);
    }

    @Override
    public CompletableFuture<long[]> findTabletsOnLocalhost() {
        return client.findTabletsOnLocalhost();
    }

    @Override
    public CompletableFuture<Long> incrementGeneration(long tabletId, long expiredAt) {
        return client.incrementGeneration(tabletId, expiredAt);
    }

    @Override
    public CompletableFuture<Void> writeAndRenameAndDeleteAndConcat(long tabletId, long gen, List<Write> writes, List<Rename> renames, List<NameRange> deletes, List<Concat> concats, long expiredAt) {
        return client.writeAndRenameAndDeleteAndConcat(tabletId, gen, writes, renames, deletes, concats, expiredAt);
    }

    @Override
    public CompletableFuture<Void> copyRange(long tabletId, long gen, NameRange nameRange, String addPrefix, String removePrefix, long expiredAt) {
        return client.copyRange(tabletId, gen, nameRange, addPrefix, removePrefix, expiredAt);
    }

    @Override
    public CompletableFuture<KvReadRangeResult> readRange(long tabletId, long gen, NameRange nameRange, boolean includeData, long limitBytes, long expiredAt) {
        return client.readRange(tabletId, gen, nameRange, includeData, limitBytes, expiredAt);
    }

    @Override
    public CompletableFuture<Optional<byte[]>> readData(long tabletId, long gen, String name, long offset, long length, long expiredAt, MsgbusKv.TKeyValueRequest.EPriority priority) {
        return client.readData(tabletId, gen, name, offset, length, expiredAt, priority);
    }

    public synchronized void setV2Enabled(boolean v2Enabled) {
        if (v2Enabled && clientV2 != null) {
            this.client = clientV2;
        } else {
            this.client = clientV1;
        }
    }
}
