package ru.yandex.kikimr.client.kv;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.kikimr.proto.MsgbusKv;
import ru.yandex.kikimr.util.NameRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class KvCommandCloneRange extends KvCommandTyped<MsgbusKv.TKeyValueRequest.TCmdCopyRange, MsgbusKv.TKeyValueResponse.TCopyRangeResult> {

    private final NameRange range;
    private final String addPrefix;
    private final String removePrefix;

    public KvCommandCloneRange(NameRange range, String addPrefix, String removePrefix) {
        this.range = range;
        this.addPrefix = addPrefix;
        this.removePrefix = removePrefix;
    }

    @Override
    protected MsgbusKv.TKeyValueRequest.TCmdCopyRange makeQ() {
        MsgbusKv.TKeyValueRequest.TCmdCopyRange.Builder b = MsgbusKv.TKeyValueRequest.TCmdCopyRange.newBuilder();
        b.setRange(KvCommandReadRange.toKvRange(range));
        b.setPrefixToAdd(ByteString.copyFromUtf8(addPrefix));
        b.setPrefixToRemove(ByteString.copyFromUtf8(removePrefix));
        return b.build();
    }

    @Override
    protected void updateCounters(MsgbusKv.TKeyValueResponse.TCopyRangeResult response, KvCounters counters) {
    }

    @Override
    public KvCommandType<MsgbusKv.TKeyValueRequest.TCmdCopyRange, MsgbusKv.TKeyValueResponse.TCopyRangeResult> type() {
        return KvCommandType.clone;
    }
}
