package ru.yandex.kikimr.client.kv;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.kikimr.proto.MsgbusKv;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class KvCommandConcat extends KvCommandTyped<MsgbusKv.TKeyValueRequest.TCmdConcat, MsgbusKv.TKeyValueResponse.TConcatResult> {

    private final List<String> inputs;
    private final String output;
    private final boolean keepInputs;

    public KvCommandConcat(List<String> inputs, String output, boolean keepInputs) {
        this.inputs = inputs;
        this.output = output;
        this.keepInputs = keepInputs;
    }

    @Override
    public KvCommandType<MsgbusKv.TKeyValueRequest.TCmdConcat, MsgbusKv.TKeyValueResponse.TConcatResult> type() {
        return KvCommandType.concat;
    }

    @Override
    protected MsgbusKv.TKeyValueRequest.TCmdConcat makeQ() {
        MsgbusKv.TKeyValueRequest.TCmdConcat.Builder q = MsgbusKv.TKeyValueRequest.TCmdConcat.newBuilder();
        for (String input : inputs) {
            q.addInputKeys(ByteString.copyFromUtf8(input));
        }
        q.setOutputKey(ByteString.copyFromUtf8(output));
        q.setKeepInputs(keepInputs);

        return q.build();
    }

    @Override
    protected void updateCounters(MsgbusKv.TKeyValueResponse.TConcatResult response, KvCounters counters) {
    }
}
