package ru.yandex.kikimr.client.kv;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.kikimr.proto.MsgbusKv;
import ru.yandex.kikimr.util.NameRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class KvCommandDeleteRange extends KvCommandTyped<MsgbusKv.TKeyValueRequest.TCmdDeleteRange, MsgbusKv.TKeyValueResponse.TDeleteRangeResult> {
    private final NameRange nameRange;

    public KvCommandDeleteRange(NameRange nameRange) {
        this.nameRange = nameRange;
    }

    @Override
    public KvCommandType<MsgbusKv.TKeyValueRequest.TCmdDeleteRange, MsgbusKv.TKeyValueResponse.TDeleteRangeResult> type() {
        return KvCommandType.deleteRange;
    }

    @Override
    protected MsgbusKv.TKeyValueRequest.TCmdDeleteRange makeQ() {
        MsgbusKv.TKeyValueRequest.TCmdDeleteRange.Builder r = MsgbusKv.TKeyValueRequest.TCmdDeleteRange.newBuilder();
        r.setRange(KvCommandReadRange.toKvRange(nameRange));
        return r.build();
    }

    @Override
    protected void updateCounters(MsgbusKv.TKeyValueResponse.TDeleteRangeResult response, KvCounters counters) {
    }
}
