package ru.yandex.kikimr.client.kv;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.kikimr.proto.MsgbusKv;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class KvCommandRename extends KvCommandTyped<MsgbusKv.TKeyValueRequest.TCmdRename, MsgbusKv.TKeyValueResponse.TRenameResult> {

    private final String from;
    private final String to;

    public KvCommandRename(String from, String to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public KvCommandType<MsgbusKv.TKeyValueRequest.TCmdRename, MsgbusKv.TKeyValueResponse.TRenameResult> type() {
        return KvCommandType.rename;
    }

    @Override
    protected MsgbusKv.TKeyValueRequest.TCmdRename makeQ() {
        MsgbusKv.TKeyValueRequest.TCmdRename.Builder r = MsgbusKv.TKeyValueRequest.TCmdRename.newBuilder();
        r.setOldKey(ByteString.copyFromUtf8(from));
        r.setNewKey(ByteString.copyFromUtf8(to));
        return r.build();
    }

    @Override
    protected void updateCounters(MsgbusKv.TKeyValueResponse.TRenameResult response, KvCounters counters) {
    }
}
