package ru.yandex.kikimr.client.kv;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Message;

import ru.yandex.kikimr.client.ReplyStatus;
import ru.yandex.kikimr.proto.MsgbusKv;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public abstract class KvCommandTyped<Q extends Message, A extends Message> extends KvCommandUntyped {

    @Override
    public abstract KvCommandType<Q, A> type();

    protected abstract Q makeQ();

    protected Q makeQForDiag() {
        return makeQ();
    }

    private int index = -1;
    private A response;

    @Override
    public void addTo(MsgbusKv.TKeyValueRequest.Builder request) {
        if (index >= 0) {
            throw new IllegalStateException();
        }
        index = type().addRequest(request, makeQ());
    }

    @Override
    public void checkResponse(MsgbusKv.TKeyValueResponse keyValueResponse, KvCounters counters) {
        if (response != null) {
            throw new IllegalStateException();
        }
        this.response = type().getResponse(keyValueResponse, index);
        checkStatus(this.response);
        updateCounters(this.response, counters);
    }

    protected void checkStatus(A response) {
        int status = type().getResponseStatus(this.response);
        ReplyStatus.checkOk(status, makeQForDiag(), response);
    }

    protected abstract void updateCounters(A response, KvCounters counters);

    @Nonnull
    public A getResponse() {
        if (response == null) {
            throw new IllegalStateException();
        }
        return response;
    }
}
