package ru.yandex.kikimr.client.kv;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.kikimr.proto.MsgbusKv;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class KvCommandWrite extends KvCommandTyped<MsgbusKv.TKeyValueRequest.TCmdWrite, MsgbusKv.TKeyValueResponse.TWriteResult> {

    private final String key;
    private final ByteString value;
    private final MsgbusKv.TKeyValueRequest.EPriority priority;
    private final MsgbusKv.TKeyValueRequest.EStorageChannel storageChannel;

    public KvCommandWrite(String key, byte[] value,
        MsgbusKv.TKeyValueRequest.EStorageChannel storageChannel, MsgbusKv.TKeyValueRequest.EPriority priority)
    {
        this.key = key;
        this.storageChannel = storageChannel;
        this.value = ByteString.copyFrom(value);
        this.priority = priority;
    }

    public KvCommandWrite(
        String key, ByteString value,
        MsgbusKv.TKeyValueRequest.EStorageChannel storageChannel, MsgbusKv.TKeyValueRequest.EPriority priority)
    {
        this.key = key;
        this.value = value;
        this.storageChannel = storageChannel;
        this.priority = priority;
    }

    @Override
    public KvCommandType<MsgbusKv.TKeyValueRequest.TCmdWrite, MsgbusKv.TKeyValueResponse.TWriteResult> type() {
        return KvCommandType.write;
    }

    @Override
    protected MsgbusKv.TKeyValueRequest.TCmdWrite makeQ() {
        MsgbusKv.TKeyValueRequest.TCmdWrite.Builder r = MsgbusKv.TKeyValueRequest.TCmdWrite.newBuilder();
        r.setKey(ByteString.copyFromUtf8(key));
        r.setValue(value);
        r.setStorageChannel(storageChannel);
        r.setPriority(priority);
        return r.build();
    }

    @Override
    protected MsgbusKv.TKeyValueRequest.TCmdWrite makeQForDiag() {
        return super.makeQForDiag().toBuilder().clearValue().build();
    }

    @Override
    protected void updateCounters(MsgbusKv.TKeyValueResponse.TWriteResult response, KvCounters counters) {
        counters.writeCompleted(1, value.size());
    }
}
