package ru.yandex.kikimr.client.kv;

import java.util.concurrent.atomic.AtomicLong;

/**
 * @author Stepan Koltsov
 */
public class KvCounters {

    public AtomicLong bytesWritten = new AtomicLong();
    public AtomicLong filesWritten = new AtomicLong();
    public AtomicLong bytesRead = new AtomicLong();
    public AtomicLong filesRead = new AtomicLong();

    public void readCompleted(int fileCount, long bytes) {
        filesRead.addAndGet(fileCount);
        bytesRead.addAndGet(bytes);
    }

    public void writeCompleted(int fileCount, long bytes) {
        filesWritten.addAndGet(fileCount);
        bytesWritten.addAndGet(bytes);
    }

}
