package ru.yandex.kikimr.client.kv;

/**
 * @author Stepan Koltsov
 */
public class KvTabletIdAndGen {
    private final long tabletId;
    private final long gen;

    public KvTabletIdAndGen(long tabletId, long gen) {
        this.tabletId = tabletId;
        this.gen = gen;
    }

    public long getTabletId() {
        return tabletId;
    }

    public long getGen() {
        return gen;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        KvTabletIdAndGen that = (KvTabletIdAndGen) o;

        if (tabletId != that.tabletId) return false;
        return gen == that.gen;

    }

    @Override
    public int hashCode() {
        int result = (int) (tabletId ^ (tabletId >>> 32));
        result = 31 * result + (int) (gen ^ (gen >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return Long.toUnsignedString(tabletId) + "/" + gen;
    }
}
