package ru.yandex.kikimr.client.kv;

import javax.annotation.Nonnull;

import ru.yandex.kikimr.util.NameRange;
import ru.yandex.misc.lang.CharacterUtils;

/**
 * @author Stepan Koltsov
 */
public class StringMicroUtils {

    public static NameRange asciiPrefixToRange(@Nonnull String prefix) {
        String r = asciiPrefixToUpperBound(prefix);
        return new NameRange(prefix, true, r, false);
    }

    private static String asciiPrefixToUpperBound(@Nonnull String prefix) {
        char[] chars = prefix.toCharArray();
        if (chars.length == 0) {
            throw new IllegalArgumentException("TODO");
        }

        char last = chars[chars.length - 1];
        if (last == Character.MAX_VALUE) {
            throw new RuntimeException("TODO");
        }
        ++last;
        if (!CharacterUtils.isAsciiPrintable(last)) {
            throw new RuntimeException("TODO");
        }
        chars[chars.length - 1] = last;
        return new String(chars);
    }

}
