package ru.yandex.kikimr.client.kv.commands;

import java.util.List;

import com.yandex.ydb.yndx.rate_limiter.ExecuteTransactionRequest;

import ru.yandex.kikimr.client.kv.KikimrKvClient;

public record Concat(List<String> inputKeys, String outputKey, boolean keepIndex) implements Command {

    public static Concat fromV1Command(KikimrKvClient.Concat cmd) {
        return new Concat(cmd.getInputs(), cmd.getOutput(), cmd.isKeepInputs());
    }

    @Override
    public ExecuteTransactionRequest.Command toProtoCommand() {
        return ExecuteTransactionRequest.Command.newBuilder().setConcat(
                ExecuteTransactionRequest.Command.Concat.newBuilder()
                        .setKeepInputs(keepIndex).setOutputKey(outputKey).addAllInputKeys(inputKeys).build()
        ).build();
    }
}
