package ru.yandex.kikimr.client.kv.commands;

import com.yandex.ydb.yndx.rate_limiter.ExecuteTransactionRequest;

public record CopyRange(KeyRange keyRange, String prefixToRemove, String prefixToAdd) implements Command {

    @Override
    public ExecuteTransactionRequest.Command toProtoCommand() {
        return ExecuteTransactionRequest.Command.newBuilder()
                .setCopyRange(
                        ExecuteTransactionRequest.Command.CopyRange.newBuilder()
                                .setRange(keyRange.toProto())
                                .setPrefixToAdd(prefixToAdd)
                                .setPrefixToRemove(prefixToRemove)
                                .build())
                .build();
    }
}
