package ru.yandex.kikimr.client.kv.commands;

import com.yandex.ydb.yndx.rate_limiter.ExecuteTransactionRequest;

import ru.yandex.kikimr.util.NameRange;

public record DeleteRange(KeyRange keyRange) implements Command {

    public static DeleteRange fromV1Command(NameRange cmd) {
        return new DeleteRange(new KeyRange(cmd));
    }

    @Override
    public ExecuteTransactionRequest.Command toProtoCommand() {
        return ExecuteTransactionRequest.Command.newBuilder()
                .setDeleteRange(
                        ExecuteTransactionRequest.Command.DeleteRange.newBuilder().setRange(keyRange.toProto()).build())
                .build();
    }
}
