package ru.yandex.kikimr.client.kv.commands;

import com.yandex.ydb.yndx.rate_limiter.Priorities;

import ru.yandex.kikimr.proto.MsgbusKv;

/**
 * @author senyasdr
 */
public enum Priority {
    PRIORITY_UNSPECIFIED(Priorities.Priority.PRIORITY_UNSPECIFIED),
    // High priority for user-initiated operations, the default priority.
    PRIORITY_REALTIME(Priorities.Priority.PRIORITY_REALTIME),
    // Low priority for background system activity.
    PRIORITY_BACKGROUND(Priorities.Priority.PRIORITY_BACKGROUND);

    private final Priorities.Priority proto;

    Priority(Priorities.Priority proto) {
        this.proto = proto;
    }

    public Priorities.Priority getProto() {
        return this.proto;
    }

    public static Priority fromV1(MsgbusKv.TKeyValueRequest.EPriority p) {
        if (MsgbusKv.TKeyValueRequest.EPriority.BACKGROUND.equals(p)) {
            return PRIORITY_BACKGROUND;
        }
        return PRIORITY_REALTIME;
    }

}
