package ru.yandex.kikimr.client.kv.commands;

import com.yandex.ydb.yndx.rate_limiter.ExecuteTransactionRequest;

import ru.yandex.kikimr.client.kv.KikimrKvClient;

public record Rename(String oldKey, String newKey) implements Command {
    public static Rename fromV1Command(KikimrKvClient.Rename cmd) {
        return new Rename(cmd.getFrom(), cmd.getTo());
    }

    public ExecuteTransactionRequest.Command toProtoCommand() {
        return ExecuteTransactionRequest.Command.newBuilder()
                .setRename(
                        ExecuteTransactionRequest.Command.Rename.newBuilder()
                                .setNewKey(newKey).setOldKey(oldKey)
                                .build())
                .build();
    }
}
