package ru.yandex.kikimr.client.kv.commands;

import com.google.protobuf.ByteString;
import com.yandex.ydb.yndx.rate_limiter.ExecuteTransactionRequest;

import ru.yandex.kikimr.client.kv.KikimrKvClient;

public record Write(String key, ByteString value, int storageChannel, Priority priority) implements Command {

    public static Write fromV1Command(KikimrKvClient.Write cmd) {
        return new Write(cmd.getName(), cmd.getValue(), cmd.getStorageChannel().getNumber(), Priority.fromV1(cmd.getPriority()));
    }

    @Override
    public ExecuteTransactionRequest.Command toProtoCommand() {
        return ExecuteTransactionRequest.Command.newBuilder()
                .setWrite(
                        ExecuteTransactionRequest.Command.Write.newBuilder()
                                .setKey(key)
                                .setValue(value)
                                .setStorageChannel(storageChannel)
                                .setPriority(priority.getProto())
                                .build())
                .build();
    }
}
