package ru.yandex.kikimr.client.kv.noderesolver;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import com.google.common.net.HostAndPort;
import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.Status;
import com.yandex.ydb.yndx.rate_limiter.AcquireLockResult;
import com.yandex.ydb.yndx.rate_limiter.DescribeVolumeResult;
import com.yandex.ydb.yndx.rate_limiter.ExecuteTransactionResult;
import com.yandex.ydb.yndx.rate_limiter.ListLocalPartitionsResult;
import com.yandex.ydb.yndx.rate_limiter.ListRangeResult;
import com.yandex.ydb.yndx.rate_limiter.ReadRangeResult;
import com.yandex.ydb.yndx.rate_limiter.ReadResult;

import ru.yandex.kikimr.client.kv.commands.Command;
import ru.yandex.kikimr.client.kv.commands.KeyRange;
import ru.yandex.kikimr.client.kv.commands.Priority;

/**
 * @author senyasdr
 */
public class NodeStub implements Node {

    private final int nodeId;
    private final HostAndPort hostAndPort;

    private boolean isClosed = false;

    public NodeStub(int nodeId, HostAndPort hostAndPort) {
        this.nodeId = nodeId;
        this.hostAndPort = hostAndPort;
    }

    @Override
    public int nodeId() {
        return nodeId;
    }

    @Override
    public HostAndPort hostAndPort() {
        return hostAndPort;
    }

    @Override
    public boolean isClosed() {
        return isClosed;
    }

    @Override
    public CompletableFuture<Result<ListLocalPartitionsResult>> listLocalPartitions(String path) {
        return CompletableFuture.completedFuture(Result.success(ListLocalPartitionsResult.getDefaultInstance()));
    }

    @Override
    public CompletableFuture<Result<ListLocalPartitionsResult>> listLocalPartitions(int nodeId, String path) {
        return CompletableFuture.completedFuture(Result.success(ListLocalPartitionsResult.getDefaultInstance()));
    }

    @Override
    public CompletableFuture<Status> createKvVolume(String path, int count) {
        return CompletableFuture.completedFuture(Status.SUCCESS);
    }

    @Override
    public CompletableFuture<Status> dropKvVolume(String path) {
        return CompletableFuture.completedFuture(Status.SUCCESS);
    }

    @Override
    public CompletableFuture<Status> alterVolume(String path, int newPartitionCount) {
        return CompletableFuture.completedFuture(Status.SUCCESS);
    }

    @Override
    public CompletableFuture<Result<DescribeVolumeResult>> describeVolume(String path) {
        return CompletableFuture.completedFuture(Result.success(DescribeVolumeResult.getDefaultInstance()));
    }

    @Override
    public CompletableFuture<Result<AcquireLockResult>> acquireLock(long partitionId, String path, long expiredAt) {
        return CompletableFuture.completedFuture(Result.success(AcquireLockResult.getDefaultInstance()));
    }

    @Override
    public CompletableFuture<Result<ReadResult>> read(String path, long partitionId, String key, long gen, long offset, long size, long limitBytes) {
        return CompletableFuture.completedFuture(Result.success(ReadResult.getDefaultInstance()));
    }

    @Override
    public CompletableFuture<Result<ExecuteTransactionResult>> executeTransaction(List<Command> commands, String path, long partitionId, long gen) {
        return CompletableFuture.completedFuture(Result.success(ExecuteTransactionResult.getDefaultInstance()));
    }

    @Override
    public CompletableFuture<Result<ReadRangeResult>> readRange(String path, long partitionId, KeyRange keyRange, long generation, long limitBytes, Priority priority) {
        return CompletableFuture.completedFuture(Result.success(ReadRangeResult.getDefaultInstance()));
    }

    @Override
    public CompletableFuture<Result<ListRangeResult>> listRange(String path, long partitionId, KeyRange range, long generation, long limitBytes) {
        return CompletableFuture.completedFuture(Result.success(ListRangeResult.getDefaultInstance()));
    }

    @Override
    public void close() {
        isClosed = true;
    }
}
