package ru.yandex.kikimr.client.kv.transport;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.net.HostAndPort;
import com.yandex.ydb.core.grpc.GrpcTransport;

import ru.yandex.kikimr.client.kv.noderesolver.Node;
import ru.yandex.kikimr.client.kv.noderesolver.NodeImpl;

/**
 * @author senyasdr
 */
@SuppressWarnings("UnstableApiUsage")
@ParametersAreNonnullByDefault
public class GrpcNodeFactoryImpl implements NodeFactory {

    private final GrpcTransportSettings settings;

    public GrpcNodeFactoryImpl(GrpcTransportSettings settings) {
        this.settings = settings;
    }

    @Override
    public Node createNode(int nodeId, HostAndPort address) {
        var transport = GrpcTransport.forHost(address.getHost(), address.getPort())
                .withCallExecutor(settings.callExecutor)
                .withAuthProvider(settings.authProvider)
                .withDataBase(settings.database);

        if (settings.useTLS) {
            if (settings.cert.isEmpty()) {
                transport.withSecureConnection();
            } else {
                transport.withSecureConnection(settings.cert.toByteArray());
            }
        }
        transport.withChannelInitializer(settings.channelInitializer);
        return new NodeImpl(nodeId, address, transport.build());
    }
}
