package ru.yandex.kikimr.grpc;

import java.util.concurrent.CompletableFuture;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;


/**
 * temporarily copy-pasted from https://a.yandex-team.ru/arc/trunk/arcadia/kikimr/public/sdk/java/core/src/grpc/UnaryStreamToFuture.java
 *
 * @author Sergey Polovko
 */
public class UnaryStreamToFuture<T> extends ClientCall.Listener<T> {

    private final CompletableFuture<T> responseFuture;
    private T value;

    public UnaryStreamToFuture(CompletableFuture<T> responseFuture) {
        this.responseFuture = responseFuture;
    }

    @Override
    public void onMessage(T value) {
        if (this.value != null) {
            StatusRuntimeException ex = Status.INTERNAL
                .withDescription("More than one value received for unary call")
                .asRuntimeException();
            responseFuture.completeExceptionally(ex);
        }
        this.value = value;
    }

    @Override
    public void onClose(Status status, Metadata trailers) {
        if (status.isOk()) {
            if (value == null) {
                // No value received so mark the future as an error
                StatusRuntimeException ex = Status.INTERNAL
                    .withDescription("No value received for unary call")
                    .asRuntimeException(trailers);
                responseFuture.completeExceptionally(ex);
            } else {
                responseFuture.complete(value);
            }
        } else {
            responseFuture.completeExceptionally(status.asRuntimeException(trailers));
        }
    }
}
