package ru.yandex.kikimr.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import com.google.common.net.HostAndPort;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * @author Sergey Polovko
 */
public class KikimrHosts {

    public static final int DEFAULT_GRPC_PORT = 2135;

    // Kikimr server for these destinations can be started with arcadia/solomon/kikimr-local-run/all.sh
    public static final List<HostAndPort> TEST = fromEnvOr("solomon-dev-myt-00.search.yandex.net:" + DEFAULT_GRPC_PORT);

    public static List<HostAndPort> fromEnvOr(String... defaultHosts) {
        String[] hosts = defaultHosts;

        String kikimrHosts = System.getenv("KIKIMR_HOSTS");
        if (StringUtils.isNotBlank(kikimrHosts)) {
            hosts = StringUtils.split(kikimrHosts, ',');
        }

        return of(hosts);
    }

    public static List<HostAndPort> of(String... hosts) {
        return of(Arrays.asList(hosts));
    }

    public static List<HostAndPort> of(List<String> hosts) {
        return of(hosts, DEFAULT_GRPC_PORT);
    }

    public static List<HostAndPort> of(List<String> hosts, int defaultPort) {
        return hosts.stream()
            .map(h -> parse(h, defaultPort))
            .collect(Collectors.toList());
    }

    @Nonnull
    private static HostAndPort parse(String host, int defaultPort) {
        String hostTrimmed = StringUtils.trim(host);
        int port = defaultPort;

        if (hostTrimmed.contains(":")) {
            String[] hostPort = StringUtils.split(hostTrimmed, ':');
            Validate.isTrue(hostPort.length == 2);
            hostTrimmed = hostPort[0];
            port = Integer.parseInt(hostPort[1]);
        }

        return HostAndPort.fromParts(hostTrimmed, port);
    }
}
