package ru.yandex.kikimr.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.kikimr.client.KikimrAsyncRetry.RetryConfig;
import ru.yandex.kikimr.proto.Msgbus;


/**
 * @author Sergey Polovko
 */
public class KikimrAsyncRetryTest {

    private final RetryConfig retryConfig = RetryConfig.maxRetries(3);

    @Test
    public void alwaysOk() {
        AtomicInteger count = new AtomicInteger();
        CompletableFuture<Integer> future = KikimrAsyncRetry.withRetries(retryConfig, () -> {
            count.incrementAndGet();
            return CompletableFuture.completedFuture(42);
        });

        Assert.assertEquals(42, future.join().intValue());
        Assert.assertEquals(1, count.get());
    }

    @Test
    public void alwaysFail() {
        AtomicInteger count = new AtomicInteger();
        CompletableFuture<Integer> future = KikimrAsyncRetry.withRetries(retryConfig, () -> {
            count.incrementAndGet();
            return futureWithException();
        });

        try {
            future.join();
            Assert.fail("expected exception not thrown");
        } catch (Exception e) {
            // expected
        }

        Assert.assertEquals(retryConfig.getMaxRetries() + 1, count.get());
    }

    @Test
    public void oneFail() {
        AtomicInteger count = new AtomicInteger();
        CompletableFuture<Integer> future = KikimrAsyncRetry.withRetries(retryConfig, () -> {
            if (count.incrementAndGet() == 1) {
                return futureWithException();
            }
            return CompletableFuture.completedFuture(42);
        });

        Assert.assertEquals(42, future.join().intValue());
        Assert.assertEquals(2, count.get());
    }

    private static <T> CompletableFuture<T> futureWithException() {
        return CompletableFuture.failedFuture(new KikimrAnyResponseException(
            Msgbus.TResponse.getDefaultInstance(),
            "read failed"));
    }
}
