package ru.yandex.kikimr.client;

import java.util.stream.Collectors;
import java.util.stream.IntStream;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class ReplyStatusTest {

    @Test
    public void trimTooLong() {
        Assert.assertEquals("abcd", ReplyStatus.trimTooLong("abcd"));

        {
            String longString = IntStream.range(0, 1000).mapToObj(x -> "x").collect(Collectors.joining());
            Assert.assertTrue(ReplyStatus.trimTooLong(longString).endsWith("..."));
        }

        // check it doesn't crash on any input
        for (int i = 0; i < 1000; ++i) {
            String s = IntStream.range(0, i).mapToObj(x -> "x").collect(Collectors.joining());
            ReplyStatus.trimTooLong(s);
        }
    }

}
