package ru.yandex.kikimr.client.kv.inMem;

import java.util.Arrays;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.kikimr.client.kv.KikimrKvClientSync;

/**
 * @author Stepan Koltsov
 */
public class KikimrKvClientInMemTest {

    private final KikimrKvClientInMem kikimrKvClient = new KikimrKvClientInMem();
    private final KikimrKvClientSync kikimrKvClientSync = new KikimrKvClientSync(kikimrKvClient);

    @Test
    public void simple() {
        long tabletId = kikimrKvClient.createKvTablet();
        long gen = kikimrKvClientSync.incrementGeneration(tabletId);

        byte[] w = { 10, 20 };
        kikimrKvClientSync.writeDefault(tabletId, gen, "aa", w);

        byte[] r = kikimrKvClientSync.readData(tabletId, gen, "aa", 0, -1).get();
        Assert.assertArrayEquals(w, r);
    }

    @Test
    public void createAndFindTablets() {
        kikimrKvClient.createKvTablets("/kv", 3).join();
        long[] tabletIds = kikimrKvClient.resolveKvTablets("/kv").join();
        long[] localTabletIds = kikimrKvClient.findTabletsOnLocalhost().join();

        Arrays.sort(tabletIds);
        Arrays.sort(localTabletIds);

        Assert.assertArrayEquals(tabletIds, localTabletIds);
    }
}
