package ru.yandex.kikimr.util;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class NameRangeTest {

    @Test
    public void includes() {
        Assert.assertFalse(NameRange.inclusive("b", "d").includes("a"));
        Assert.assertTrue(NameRange.inclusive("b", "d").includes("b"));
        Assert.assertTrue(NameRange.inclusive("b", "d").includes("c"));
        Assert.assertTrue(NameRange.inclusive("b", "d").includes("d"));
        Assert.assertFalse(NameRange.inclusive("b", "d").includes("e"));

        Assert.assertFalse(NameRange.exclusive("b", "d").includes("a"));
        Assert.assertFalse(NameRange.exclusive("b", "d").includes("b"));
        Assert.assertTrue(NameRange.exclusive("b", "d").includes("c"));
        Assert.assertFalse(NameRange.exclusive("b", "d").includes("d"));
        Assert.assertFalse(NameRange.exclusive("b", "d").includes("e"));

        Assert.assertFalse(NameRange.inclusiveExclusive("b", "d").includes("a"));
        Assert.assertTrue(NameRange.inclusiveExclusive("b", "d").includes("b"));
        Assert.assertTrue(NameRange.inclusiveExclusive("b", "d").includes("c"));
        Assert.assertFalse(NameRange.inclusiveExclusive("b", "d").includes("d"));
        Assert.assertFalse(NameRange.inclusiveExclusive("b", "d").includes("e"));
    }

}
