package ru.yandex.solomon.labels;

import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class FormatLabel {

    public static final String DELIMITER = "&";

    public static String formatLabel(String pattern, Function<String, String> resolver) {
        return InterpolatedString.parse(pattern).eval(resolver);
    }

    public static String formatLabel(String pattern, Labels labels) {
        return formatLabel(pattern, key -> {
            Label label = labels.findByKey(key);
            return label == null ? "" : label.getValue();
        });
    }

    public static String format(Stream<Label> labels) {
        return labels.map(l -> l.getKey() + '=' + l.getValue())
            .collect(Collectors.joining(DELIMITER));
    }
}
