package ru.yandex.solomon.labels;

import java.util.regex.Pattern;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class LabelValidator {
    /**
     * Keep in sync with {@link #validChars}.
     */
    public static final Pattern validCharsPattern = Pattern.compile("[-0-9a-zA-Z_/]+");

    /**
     * Keep in sync with {@link #validCharsPattern}.
     */
    private static final boolean[] validChars;
    static {
        validChars = new boolean['z' + 1];
        for (char c : "-_/.".toCharArray()) {
            validChars[c] = true;
        }
        for (char c = '0'; c <= '9'; ++c) {
            validChars[c] = true;
        }
        for (char c = 'a'; c <= 'z'; ++c) {
            validChars[c] = true;
        }
        for (char c = 'A'; c <= 'Z'; ++c) {
            validChars[c] = true;
        }
    }

    public static boolean isValidCount(int count) {
        return count >= 0 && count <= 16;
    }

    public static boolean isValidChar(char c) {
        return c < validChars.length && validChars[c];
    }

    public static boolean isValidNameChars(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (!isValidChar(name.charAt(i))) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidValue(@Nullable String value) {
        return value != null && value.length() > 0 && value.length() <= 200
                // TODO: https://st.yandex-team.ru/SOLOMON-275
                //&& acceptableValue.matcher(value).matches()
                ;
    }

    public static boolean isValidName(@Nullable String name) {
        return name != null
                && name.length() > 0
                && name.length() < 50
                && isValidNameChars(name)
//                && !LabelForbiddenNames.isForbiddenName(name)
                ;
    }

    @Nonnull
    public static String normalize(String value) {
        return value.replace(' ', '_');
    }
}
