package ru.yandex.solomon.labels;

/**
 * @author Sergey Polovko
 */
public class LabelValueGlob {

    private static final char STAR = '*';
    private static final char QUESTION = '?';


    public static boolean glob(String pattern, String value) {
        if (isGlob(pattern)) {
            return match(pattern, value);
        } else {
            return pattern.equals(value);
        }
    }

    public static boolean isGlob(String pattern) {
        return pattern.indexOf(STAR) != -1 || pattern.indexOf(QUESTION) != -1;
    }

    public static boolean match(String pattern, String value) {
        return matchRecur(pattern, value, 0 , 0);
    }

    private static boolean matchRecur(String pattern, String value, int pStart, int vStart) {
        int pLen = pattern.length();
        int vLen = value.length();

        int pIndex = pStart;
        int vIndex = vStart;

        while (pIndex < pLen && vIndex < vLen) {
            char pChar = pattern.charAt(pIndex);
            if (pChar == QUESTION || pChar == value.charAt(vIndex)) {
                pIndex++;
                vIndex++;
            } else if (pChar == STAR) {
                pIndex++;
                if (pIndex < pLen) {
                    for ( ; vIndex < vLen; vIndex++) {
                        if (matchRecur(pattern, value, pIndex, vIndex)) {
                            return true;
                        }
                    }
                    return false;
                }
                return true;
            } else {
                return false;
            }
        }

        while (pIndex < pLen && pattern.charAt(pIndex) == STAR) {
            pIndex++;
        }

        return pIndex == pLen && vIndex == vLen;
    }

}
