package ru.yandex.solomon.labels.protobuf;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class LabelConverter {
    private LabelConverter() {
    }

    public static Labels protoToLabels(ru.yandex.solomon.model.protobuf.Labels proto) {
        return protoToLabels(proto.getLabelsList());
    }

    public static Labels protoToLabels(List<ru.yandex.solomon.model.protobuf.Label> protos) {
        return protoToLabels(protos, Labels.allocator);
    }

    public static Labels protoToLabels(List<ru.yandex.solomon.model.protobuf.Label> labels, LabelAllocator allocator) {
        if (labels.isEmpty()) {
            return Labels.empty();
        }

        LabelsBuilder builder = Labels.builder(labels.size(), allocator);
        for (var label : labels) {
            builder.add(label.getKey(), label.getValue());
        }
        return builder.build();
    }

    public static LabelsBuilder protoToLabelsBuilder(
            List<ru.yandex.solomon.model.protobuf.Label> labels,
            LabelAllocator allocator)
    {
        if (labels.isEmpty()) {
            return new LabelsBuilder(0, allocator);
        }

        LabelsBuilder builder = Labels.builder(labels.size(), allocator);
        for (var label : labels) {
            builder.add(label.getKey(), label.getValue());
        }
        return builder;
    }

    public static ru.yandex.solomon.model.protobuf.Label labelToProto(Label label) {
        return ru.yandex.solomon.model.protobuf.Label.newBuilder()
                .setKey(label.getKey())
                .setValue(label.getValue())
                .build();
    }

    public static List<ru.yandex.solomon.model.protobuf.Label> labelsToProtoList(Labels labels) {
        List<ru.yandex.solomon.model.protobuf.Label> result = new ArrayList<>(labels.size());
        labels.forEach(label -> result.add(labelToProto(label)));
        return result;
    }

    public static void addLabels(ru.yandex.solomon.model.protobuf.Labels.Builder builder, Labels labels) {
        labels.forEach(label -> {
            builder.addLabelsBuilder()
                .setKey(label.getKey())
                .setValue(label.getValue());
        });
    }

    public static ru.yandex.solomon.model.protobuf.Labels labelsToProto(Labels labels) {
        if (labels.isEmpty()) {
            return ru.yandex.solomon.model.protobuf.Labels.getDefaultInstance();
        }
        var builder = ru.yandex.solomon.model.protobuf.Labels.newBuilder();
        addLabels(builder, labels);
        return builder.build();
    }
}
