package ru.yandex.solomon.labels.protobuf;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.labels.query.Selector;
import ru.yandex.solomon.labels.query.SelectorType;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.labels.query.SelectorsBuilder;
import ru.yandex.solomon.model.protobuf.MatchType;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class LabelSelectorConverter {
    private LabelSelectorConverter() {
    }

    public static Selectors protoToSelectors(ru.yandex.solomon.model.protobuf.Selectors proto) {
        SelectorsBuilder builder = Selectors.builder(proto.getNameSelector(), proto.getLabelSelectorsCount());
        for (var protoSelector : proto.getLabelSelectorsList()) {
            builder.add(protoToSelector(protoSelector));
        }
        return builder.build();
    }

    public static Selector protoToSelector(ru.yandex.solomon.model.protobuf.Selector proto) {
        return SelectorType.forNumber(proto.getMatchType().getNumber())
                .create(proto.getKey(), proto.getPattern());
    }

    public static Selectors protoToSelectors(List<ru.yandex.solomon.model.protobuf.Selector> selectors) {
        SelectorsBuilder builder = Selectors.builder(selectors.size());
        for (var selector : selectors) {
            builder.add(protoToSelector(selector));
        }
        return builder.build();
    }

    public static ru.yandex.solomon.model.protobuf.Selector selectorToProto(Selector selector) {
        return ru.yandex.solomon.model.protobuf.Selector.newBuilder()
            .setKey(selector.getKey())
            .setPattern(selector.getValue())
            .setMatchType(MatchType.forNumber(selector.getType().getNumber()))
            .build();
    }

    public static List<ru.yandex.solomon.model.protobuf.Selector> selectorsToProto(List<Selector> selectors) {
        return selectorsToProto(selectors.stream());
    }

    @Deprecated
    public static List<ru.yandex.solomon.model.protobuf.Selector> selectorsToProto(Selectors selectors) {
        if (!selectors.getNameSelector().isEmpty()) {
            throw new IllegalArgumentException("Unable convert selector " + Selectors.format(selectors) + " to old format");
        }
        return selectorsToProto(selectors.stream());
    }

    public static ru.yandex.solomon.model.protobuf.Selectors selectorsToNewProto(Selectors selectors) {
        return ru.yandex.solomon.model.protobuf.Selectors.newBuilder()
            .setNameSelector(selectors.getNameSelector())
            .addAllLabelSelectors(selectorsToProto(selectors.toList()))
            .build();
    }

    public static List<ru.yandex.solomon.model.protobuf.Selector> selectorsToProto(Stream<Selector> selectors) {
        return selectors
                .map(LabelSelectorConverter::selectorToProto)
                .collect(Collectors.toList());
    }
}
