package ru.yandex.solomon.labels.protobuf;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.validate.LabelValidationFilter;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class LabelValidationFilterConverter {

    public static LabelValidationFilter protoToFilter(
            ru.yandex.solomon.metabase.protobuf.LabelValidationFilter protoFilter)
    {
        switch (protoFilter) {
            case ALL:
                return LabelValidationFilter.ALL;
            case INVALID_ONLY:
                return LabelValidationFilter.INVALID_ONLY;
            case VALID_ONLY:
                return LabelValidationFilter.VALID_ONLY;
            default:
                throw new RuntimeException("unknown label validation filter: " + protoFilter);
        }
    }
}
