package ru.yandex.solomon.labels.query;

import java.util.Map;
import java.util.function.Consumer;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
final class AbsentSelector implements Selector {

    private final String key;

    AbsentSelector(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public String getValue() {
        return "-";
    }

    @Override
    public SelectorType getType() {
        return SelectorType.ABSENT;
    }

    @Override
    public boolean match(@Nullable String value) {
        return value == null;
    }

    @Override
    public <T> void forEachMatchedKey(Map<String, T> values, Consumer<T> fn) {
        // nop, because we do not store null values in index
    }

    @Override
    public Selector withKey(String key) {
        return new AbsentSelector(key);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbsentSelector)) {
            return false;
        }

        AbsentSelector that = (AbsentSelector) o;
        return key.equals(that.key);
    }

    @Override
    public int hashCode() {
        return key.hashCode();
    }

    @Override
    public String toString() {
        return "AbsentSelector{" +
            "key='" + key + '\'' +
            '}';
    }
}
