package ru.yandex.solomon.labels.query;

import java.util.Map;
import java.util.function.Consumer;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class AnySelector implements Selector {

    private final String key;

    AnySelector(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public String getValue() {
        return "*";
    }

    @Override
    public SelectorType getType() {
        return SelectorType.ANY;
    }

    @Override
    public boolean match(@Nullable String value) {
        return value != null;
    }

    @Override
    public <T> void forEachMatchedKey(Map<String, T> values, Consumer<T> fn) {
        values.values().forEach(fn);
    }

    @Override
    public Selector withKey(String key) {
        return new AnySelector(key);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnySelector)) {
            return false;
        }

        AnySelector that = (AnySelector) o;
        return key.equals(that.key);
    }

    @Override
    public int hashCode() {
        return key.hashCode();
    }

    @Override
    public String toString() {
        return "AnySelector{" +
            "key='" + key + '\'' +
            '}';
    }
}
