package ru.yandex.solomon.labels.query;

import java.util.Map;
import java.util.function.Consumer;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
final class ExactSelector implements Selector {

    private final String key;
    private final String value;

    ExactSelector(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public String getValue() {
        return value;
    }

    @Override
    public SelectorType getType() {
        return SelectorType.EXACT;
    }

    @Override
    public boolean match(@Nullable String value) {
        return this.value.equals(value);
    }

    @Override
    public <T> void forEachMatchedKey(Map<String, T> values, Consumer<T> fn) {
        T v = values.get(this.value);
        if (v != null) {
            fn.accept(v);
        }
    }

    @Override
    public Selector withKey(String key) {
        return new ExactSelector(key, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExactSelector)) {
            return false;
        }

        ExactSelector that = (ExactSelector) o;

        if (!key.equals(that.key)) {
            return false;
        }
        return value.equals(that.value);
    }

    @Override
    public int hashCode() {
        int result = key.hashCode();
        result = 31 * result + value.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ExactSelector{" +
            "key='" + key + '\'' +
            ", value='" + value + '\'' +
            '}';
    }
}
