package ru.yandex.solomon.labels.query;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
final class NotSelector implements Selector {

    private final Selector selector;
    private final SelectorType type;

    NotSelector(Selector selector, SelectorType type) {
        this.selector = selector;
        this.type = type;
    }

    @Override
    public String getKey() {
        return selector.getKey();
    }

    @Override
    public String getValue() {
        return selector.getValue();
    }

    @Override
    public SelectorType getType() {
        return type;
    }

    @Override
    public boolean match(@Nullable String value) {
        return value != null && !selector.match(value);
    }

    @Override
    public Selector withKey(String key) {
        return new NotSelector(selector.withKey(key), type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotSelector)) {
            return false;
        }

        NotSelector that = (NotSelector) o;

        if (!selector.equals(that.selector)) {
            return false;
        }
        return type == that.type;
    }

    @Override
    public int hashCode() {
        int result = selector.hashCode();
        result = 31 * result + type.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "NotSelector{" +
            "selector=" + selector +
            ", type=" + type +
            '}';
    }
}
